<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" indent="yes" encoding="utf-8"/>

	<xsl:template match="@*|node()"> <!-- copy everything, but allow for processing -->
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>

	<!-- Now, check TIG nodes for Reliability and copy only those with the highest reliability.
		Reliability 1 "Not Verified", 2 "Minimum reliability (Automatically assigned)",
		Reliability 3 "Reliable", 4 "Very reliable (Manually assigned & assessed)"
		Note on Reliability Level 3:
		"This code was automatically assigned to many entries, regardless of their previous validation status, following the merger of existing databases to create IATE. Therefore some entries marked as ‘reliable’ are not necessarily so." -
		(http://iate.europa.eu/tbx/IATE%20Data%20Fields%20Explaind.htm#_Reliability_code)
	-->
	<xsl:template match="tig"> <!-- copy only term units with Reliability 3 or 4 -->
			<xsl:if test="descrip[@type='reliabilityCode']&gt;=3">
				<xsl:copy>
					<xsl:copy-of select="@*|node()"/>
				</xsl:copy>
			</xsl:if>
	</xsl:template>
</xsl:stylesheet>