<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" indent="yes" encoding="utf-8"/>

	<xsl:template match="@*|node()"> <!-- copy everything, but allow for processing -->
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="langSet"> <!-- copy only those languages that you need -->
		<xsl:choose>
			<xsl:when test="@xml:lang='en'">
				<xsl:copy>
					<xsl:copy-of select="@*|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="@xml:lang='de'">
				<xsl:copy>
					<xsl:copy-of select="@*|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="@xml:lang='fr'">
				<xsl:copy>
					<xsl:copy-of select="@*|node()"/>
				</xsl:copy>
			</xsl:when>
<!--			<xsl:otherwise></xsl:otherwise>		-->
		</xsl:choose> 
	</xsl:template>
</xsl:stylesheet>